function Component()
{
    console.log("CPU Architecture : "+systemInfo.currentCpuArchitecture);
    console.log("Kernel Type : "+systemInfo.kernelType);
    console.log("Kernel Version : "+systemInfo.kernelVersion);
    console.log("Product Name : "+systemInfo.prettyProductName);
    console.log("Product Type : "+systemInfo.productType);
    console.log("Product Version : "+systemInfo.productVersion);
    installer.setValue("TargetDir", "@ApplicationsDir@/@ProductName@"); 
    //connect events
    installer.installationFinished.connect(this, Component.prototype.installationFinishedPageIsShown);
    if(installer.isInstaller())
    {
        //hide start menu directory choice and component selection page
        installer.setDefaultPageVisible(QInstaller.StartMenuSelection, false);
        installer.setDefaultPageVisible(QInstaller.ComponentSelection, false);
        //connect events
        if(systemInfo.productType == "raspbian")
        {
            installer.addWizardPageItem( component, "RunMeCheckBoxForm", QInstaller.InstallationFinished );
            installer.finishButtonClicked.connect(this, Component.prototype.installationFinished);
        }
    }
}

Component.prototype.createOperations = function() {
    component.createOperations();
    if( systemInfo.productType == "windows" )
    {
        component.addOperation ( "CreateShortcut", "@TargetDir@\\bin\\@ProductName@.exe", "@AllUsersStartMenuProgramsPath@\\@ProductName@\\@ProductName@.lnk" );
        component.addOperation ( "CreateShortcut", "@TargetDir@\\maintenancetool.exe", "@AllUsersStartMenuProgramsPath@\\@ProductName@\\Uninstall.lnk" );
        component.addOperation ( "CreateShortcut", "@TargetDir@\\bin\\@ProductName@.exe", "@DesktopDir@\\@ProductName@.lnk");
    }
    else if ( systemInfo.kernelType == "linux" && systemInfo.currentCpuArchitecture == "x86_64" )
    {
        component.addOperation ( "InstallIcons", "@TargetDir@/bin/icons" );
        component.addOperation( "CreateDesktopEntry","@TargetDir@/bin/@ProductName@.desktop",
                                "Type=Application\nExec=@TargetDir@/bin/@ProductName@\nPath=@TargetDir@/bin\nName=@ProductName@\nGenericName=Launch @ProductName@\nIcon=@TargetDir@/bin/@ProductName@.png\nTerminal=false");
    }
    else if(systemInfo.productType == "raspbian")
    {
        //component.addOperation ( "Execute", "killall", "-9", "b2qt" )
        //component.addOperation ( "Execute", "cp", "-rf", "@TargetDir@/appcontroller", "/usr/bin/appcontroller" )
    }
}

Component.prototype.installationFinishedPageIsShown = function()
{
   var component = installer.componentByName("awamusic");
   component.maintenanceToolBinaryPath = installer.value("TargetDir");
   if(component.enabled)
   {
      if (systemInfo.productType == "windows")
      {
          if(installer.isInstaller())
          {
             //external software protection
             var copyMinderPath = component.maintenanceToolBinaryPath+"\\bin\\CMInstall.exe";
             var fileExists = installer.fileExists( copyMinderPath );
             if( fileExists )
             {
                 console.log("CMInstall detected : Execute detached "+copyMinderPath);
                 if(!installer.executeDetached(copyMinderPath))
                 {
                    installer.interrupt();
                 }
             }
          }
          component.maintenanceToolBinaryPath = "@TargetDir@\\bin\\@ProductName@.exe";
          component.maintenanceToolBinaryPath = component.maintenanceToolBinaryPath.replace(/\//g, "\\");
      }
      else if (systemInfo.productType == "osx")
      {
          component.maintenanceToolBinaryPath = "@TargetDir@/bin/@ProductName@.app/Contents/MacOS/@ProductName@";
      }
      else if(systemInfo.productType == "raspbian")
      {
        installer.execute("chmod",["+x","@TargetDir@/bin/@ProductName@"])
        installer.execute("chmod",["+x","@TargetDir@/updater"])
        installer.execute("/usr/bin/appcontroller",["--make-default","@TargetDir@/bin/@ProductName@"]);
        component.maintenanceToolBinaryPath = "@TargetDir@/bin/@ProductName@";
      }
      else
      {
          component.maintenanceToolBinaryPath = "@TargetDir@/bin/@ProductName@";
      }
   }
   else
   {
      if (systemInfo.productType == "windows")
      {
          component.maintenanceToolBinaryPath = "@TargetDir@\\maintenancetool.exe";
          component.maintenanceToolBinaryPath = component.maintenanceToolBinaryPath.replace(/\//g, "\\");
      }
      else if (systemInfo.productType == "osx")
      {
          component.maintenanceToolBinaryPath = "@TargetDir@/maintenancetool.app/Contents/MacOS/maintenancetool";
      }
      else 
      {
          component.maintenanceToolBinaryPath = "@TargetDir@/maintenancetool";
      }
   }
}

Component.prototype.installationFinished = function()
{
  var component = installer.componentByName("awamusic");
  if(component.enabled)
  {
    var isRunMeCheckBoxChecked = component.userInterface( "RunMeCheckBoxForm" ).runMeCheckBox.checked;
    if(isRunMeCheckBoxChecked)
    {
      if(systemInfo.productType == "raspbian")
      {
        installer.executeDetached("systemctl",["start","b2qt"]);
      }
    }
  }
}
